{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 2003-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.NetControlWrapper platform experimental;

{$T-,H+,X+}

interface

uses
  System.Windows.Forms,
  Borland.Vcl.Messages,
  Borland.Vcl.NetControl;

{ TNetControlWrapper }

type
  TNetEventHandler = procedure (Sender: System.Object; AArgs: System.EventArgs);
  
  TNetControlData = class(TObject)
    AssemblyName: string;
	ControlName  : string;  
  end;
  
  TNetControlWrapper = class(TNetControl)
  private
    WM_ACTIVATE_CONTROL: integer;
    FControlData: TNetControlData;
  protected  
    function GetControl: System.Windows.Forms.Control; override;
    procedure CreateHandle; override;
    procedure WndProc(var Message: TMessage); override;
    procedure Init; override;
    procedure ActivateControl;
    procedure InitControlData; virtual; abstract;
    property ControlData: TNetControlData read FControlData;
  public
  end;

implementation

uses
  Borland.Vcl.Windows,
  Borland.Vcl.Dialogs;

const
  cWinMsgID = 'Borland.Vcl.Activator.Activate';

{ TNetControlWrapper }

procedure TNetControlWrapper.Init;
begin
  inherited Init;
  FControlData := TNetControlData.Create;
  Self.InitControlData;
  WM_ACTIVATE_CONTROL := RegisterWindowMessage(cWinMsgID);
end;

procedure TNetControlWrapper.CreateHandle;
begin
  inherited CreateHandle;
  PostMessage(Self.Handle, WM_ACTIVATE_CONTROL, 0, 0);
end;

procedure TNetControlWrapper.WndProc(var Message: TMessage);
begin
  if Message.Msg = WM_ACTIVATE_CONTROL then Self.ActivateControl else inherited;
end;

function TNetControlWrapper.GetControl: System.Windows.Forms.Control;
begin
  Self.ActivateControl;
  Result := inherited GetControl; 
end;

procedure TNetControlWrapper.ActivateControl;
begin
  if not Self.Activator.Active then
    with FControlData do
      Self.Activator.Activate(AssemblyName, ControlName); 
end;

end.

